/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.PrincipalComponents;
import weka.attributeSelection.Ranker;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.filters.unsupervised.attribute.RemoveType;

public class AttributeSelectionTest
extends AbstractFilterTest {
    public AttributeSelectionTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new AttributeSelection();
    }

    public Filter getFilter(ASEvaluation evaluator, ASSearch search) {
        AttributeSelection af = new AttributeSelection();
        if (evaluator != null) {
            af.setEvaluator(evaluator);
        }
        if (search != null) {
            af.setSearch(search);
        }
        return af;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        RemoveType af = new RemoveType();
        af.setInputFormat(this.m_Instances);
        this.m_Instances = Filter.useFilter(this.m_Instances, af);
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            AttributeSelectionTest.assertTrue("Problem with AttributeTypeFilter in setup", this.m_Instances.attribute(i).type() != 2);
            ++i;
        }
    }

    public void testPrincipalComponent() {
        this.m_Filter = this.getFilter(new PrincipalComponents(), new Ranker());
        Instances result = this.useFilter();
        AttributeSelectionTest.assertTrue(this.m_Instances.numAttributes() != result.numAttributes());
    }

    public static Test suite() {
        return new TestSuite(AttributeSelectionTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(AttributeSelectionTest.suite());
    }
}

